<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/TR/WD-xsl" >
 <xsl:template match="/">
  <html>
   <body STYLE="font-family:Arial, helvetica, sans-serif; font-size:12pt;
        background-color:#EEEEEE">
    <DIV STYLE="font-weight:bold;font-size=16pt">
      <xsl:value-of select="@date"/>
    </DIV>
    <xsl:apply-templates/>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="bibliography">
    <xsl:for-each select="book" order-by="+ date">
      <DIV STYLE="background-color:#0000CC; color:#FFFFFF; padding:4px">
        <SPAN STYLE="font-weight:bold; color:white">
        <xsl:value-of select="title"/></SPAN>
      </DIV>
      <DIV STYLE="font-weight:bold">Author: <xsl:value-of select="author"/></DIV>
      <DIV STYLE="font-weight:bold">Publisher: <xsl:value-of select="publisher"/></DIV>
      <DIV>Date: <xsl:value-of select="date"/></DIV>
    </xsl:for-each>

    <xsl:for-each select="thesis" order-by="+ date">
      <DIV STYLE="background-color:#00CC00; color:#FFFFFF; padding:4px">
        <SPAN STYLE="font-weight:bold; color:white">
        <xsl:value-of select="title"/></SPAN>
      </DIV>
      <DIV STYLE="font-weight:bold">Author: <xsl:value-of select="author"/></DIV>
      <DIV STYLE="font-weight:bold">Degree: <xsl:value-of select="degree"/></DIV>
      <DIV>Date: <xsl:value-of select="date"/></DIV>
    </xsl:for-each>

    <xsl:for-each select="article" order-by="+ date">
      <DIV STYLE="background-color:#8B0000; color:#FFFFFF; padding:4px">
        <SPAN STYLE="font-weight:bold; color:white">
        <xsl:value-of select="title"/></SPAN>
      </DIV>
      <DIV STYLE="font-weight:bold">Author(s): 
        <xsl:for-each select="author"> <xsl:value-of select="."/> </xsl:for-each>
      </DIV>
      <DIV>Date: <xsl:value-of select="date"/></DIV>
    </xsl:for-each>

    <xsl:for-each select="talk" order-by="+ date">
      <DIV STYLE="background-color:#CC0099; color:#FFFFFF; padding:4px">
        <SPAN STYLE="font-weight:bold; color:white">
        <xsl:value-of select="title"/></SPAN>
      </DIV>
      <DIV STYLE="font-weight:bold">Occasion: <xsl:value-of select="occasion"/></DIV>
      <DIV>Date: <xsl:value-of select="date"/></DIV>
    </xsl:for-each>
  
  </xsl:template>

</xsl:stylesheet>
